<?php

/**
 * Class that operate on table 'wishlist'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2025-05-17 18:39
 */
class WishlistMySqlDAO implements WishlistDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return WishlistMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM wishlist WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM wishlist';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM wishlist ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param wishlist primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM wishlist WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param WishlistMySql wishlist
     */
    public function insert($wishlist) {
        $sql = 'INSERT INTO wishlist (clientid, productid, sysDate) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($wishlist->clientid);
        $sqlQuery->setNumber($wishlist->productid);
        $sqlQuery->set($wishlist->sysDate);

        $id = $this->executeInsert($sqlQuery);
        $wishlist->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param WishlistMySql wishlist
     */
    public function update($wishlist) {
        $sql = 'UPDATE wishlist SET clientid = ?, productid = ?, sysDate = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($wishlist->clientid);
        $sqlQuery->setNumber($wishlist->productid);
        $sqlQuery->set($wishlist->sysDate);

        $sqlQuery->setNumber($wishlist->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM wishlist';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM wishlist WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM wishlist WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM wishlist WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM wishlist WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM wishlist WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM wishlist WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return WishlistMySql
     */
    protected function readRow($row) {
        $wishlist = new Wishlist();

        $wishlist->id = $row['id'];
        $wishlist->clientid = $row['clientid'];
        $wishlist->productid = $row['productid'];
        $wishlist->sysDate = $row['sysDate'];
        //
        $wishlist->clientname = $row['clientname'];
        $wishlist->productName = $row['productName'];

        return $wishlist;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return WishlistMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>